@extends('user')
@section('content')
    @include('partials.breadcrumb')

 <div class="dedicated-plan">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    @include('errors.error')
                    <div class="plan-table">
                        <table class="table">
                            <thead>
                            <tr>
                                 <th scope="col">@lang('SL')</th>
                                <th scope="col">@lang('TRX')</th>
                                <th scope="col">@lang('Withdraw Amount')</th>
                                <th scope="col">@lang('Method')</th>
                                <th scope="col">@lang('Receive Amount')</th>
                                <th scope="col">@lang('Status')</th>
                                <th scope="col">@lang('Time')</th>
                            </tr>
                            </thead>

                            <tbody>
                            @if(count($invests)>0)
                                @foreach($invests as $k=>$data)
                                    <tr>
                                        <td data-label="@lang('SL')">{{++$k}}</td>
                                        <td data-label="#@lang('TRX')">{{$data->trx }}</td>
                                        <td data-label="@lang('Withdraw Amount')">{{$data->withdraw_amount }} {{$basic->currency}}</td>




                                        <td data-label="@lang('Method')">{{$data->method->name }}</td>

                                        <td data-label="@lang('Receive Amount')">
                                            <i class="icofont-money"></i>
                                            <span class="strong"> {{number_format($data->receive_currency_amount, $basic->decimal) }} </span>
                                            <span class="base-color strong">{{$data->method->name }}</span>
                                        </td>
                                        <td data-label="@lang('Status')">
                                            @if($data->status == 1)
                                                <span class="badge badge-primary"> @lang('Pending') </span>
                                            @elseif($data->status == 2)
                                                <span class="badge badge-success"> @lang('Approved') </span>
                                            @elseif($data->status == -2)
                                                <span class="badge badge-danger"> @lang('Refunded')</span>
                                            @endif
                                        </td>
                                        <td data-label="@lang('Time')">
                                            {!! date(' d M,Y h:i A', strtotime($data->created_at)) !!}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="8"><h4 class="text-center text-danger margin-top-40 margin-bottom-60"> @lang('No Data Found!')</h4></td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div>
                    {!! $invests->links() !!}
                </div>
            </div>
        </div>
    </div>

@stop
